     % close_system(gcb)
    Mask_MS     = Simulink.Mask.get(gcb);

    Model_SA    = gcb + "/Storage Settings";
    close_system(Model_SA)
    Model_AN    = Model_SA + "/Speicher/Speicheranordnung";
    Model_ZS    = Model_SA + "/HP/HP_Anordnung";
    Model_Sub   = Model_AN + "/Subsystem";

    Mask_SA     = Simulink.Mask.get(Model_SA);
    SA_TC       = Mask_SA.getDialogControl("TabContainerZwisch");

    SP_str      = Mask_MS.getParameter("Tank_Anzahl").Value;
    SP_no       = str2double(SP_str);
    ZS_str      = Mask_MS.getParameter("Zwischen_Anzahl").Value;
    ZS_no       = str2double(ZS_str);
    Tu          = Mask_MS.getParameter("Tu").Value;

    %% Vektoren Anpassen
    mux_out     = (10 + SP_no * 2) * ZS_no;
    dem_out     = (10 + (SP_no + ZS_no) * 2);
    set_param(Model_ZS + "/ZW_out_Vec", "NumInputs",ZS_str)
    set_param(Model_ZS + "/P_ZW_Vec", "NumInputs",ZS_str)
    set_param(Model_ZS + "/L_ZW_Vec", "NumInputs",ZS_str)
    set_param(Model_ZS + "/ZW_SOC", "NumInputs", ZS_str)
    set_param(Model_ZS + "/ZW_Bus", "NumInputs", ZS_str)
    set_param(Model_ZS + "/Bus_Short", "Outputs", num2str(mux_out))
    set_param(Model_ZS + "/Bus_Short_Out", "Inputs", num2str(dem_out))
    set_param(Model_Sub + "/Zwischenspeicheranzahl", "Value",ZS_str)
    set_param(Model_ZS + "/Zwischenspeicheranzahl", "Value",ZS_str)
    posy = -300;

    if SP_no == 1 || ZS_no
        for i = 1:1:12
            add_line(Model_ZS, "Bus_Short/" + num2str(i), "Bus_Short_Out/" + num2str(i))
        end
    else
        for i = 1:dem_out
            add_line(Model_ZS, "Bus_Short/" + num2str(i), "Bus_Short_Out/" + num2str(i))
        end
    end

    for i = 1:ZS_no
        i_str = num2str(i);
        n = num2str(i + SP_no);
        %% Quellspeicher einfügen
        add_block("HRS_Library/Sonstiges/HP", Model_ZS + "/HP1","MakeNameUnique","on","Position",[400 posy 550 posy + 100],"LinkStatus","none")
        set_param(Model_ZS + "/HP" + i_str +"/Speichernummer","Value",n)
        SC = get_param(Model_ZS + "/HP" + i_str + "/ZW1_Scope","ScopeConfiguration");
        SC.DataLogging = true;
        SC.DataLoggingVariableName = "HP_" + i_str;
        SC.DataLoggingSaveFormat = "Structure";
        set_param(Model_ZS + "/HP" + i_str + "/ZW1_Scope", "Name","HP_" + i_str)
        posy = posy + 200;

        %% Inputs Verbinden
        add_line(Model_ZS,"Dispensereingang_Zwischen/1", "HP" + i + "/1","autorouting","on")
        add_line(Model_ZS,"Kompressor/1", "HP" + i + "/2","autorouting","on")
        add_line(Model_ZS,"Nonfuel/1", "HP" + i + "/3","autorouting","on")
        add_line(Model_ZS,"Fueltrigger/1", "HP" + i + "/4","autorouting","on")
        add_line(Model_ZS,"Locks/2", "HP" + i + "/5","autorouting","on")
        add_line(Model_ZS,"Subsystem2/1", "HP" + i + "/6","autorouting","on")
        %% Outputs Verbinden
        add_line(Model_ZS,"HP" + i + "/1","P_ZW_Vec/" + i,"autorouting","on")
        add_line(Model_ZS,"HP" + i + "/2","L_ZW_Vec/" + i,"autorouting","on")
        add_line(Model_ZS,"HP" + i + "/3","ZW_SOC/" + i,"autorouting","on")
        add_line(Model_ZS,"HP" + i + "/4","ZW_out_Vec/" + i,"autorouting","on")
        add_line(Model_ZS,"HP" + i + "/5","ZW_Bus/" + i,"autorouting","on")
        %% Werte Festlegen

        SA_Tab          = SA_TC.addDialogControl("tab","Tab" + n);
        SA_Tab.Prompt   = "Storage " + n;

        Para_Grp        = SA_Tab.addDialogControl("group",("Para_Grp" + n));
        Para_Grp.Prompt = "Parameters for Storage " + n;   

        T0              = Mask_SA.addParameter("Type","edit","Name",("T0" + n),"Value",Tu,"Container",("Para_Grp" + n));
        T0.Prompt       = "Initial Temperature [°C]";

        P0              = Mask_SA.addParameter("Type","edit","Name",("P0" + n),"Value",num2str(100),"Container",("Para_Grp" + n));
        P0.Prompt       = "Initial Pressure [MPa]";

        VS              = Mask_SA.addParameter("Type","edit","Name",("VS" + n),"Value",num2str(1000),"Container",("Para_Grp" + n));
        VS.Prompt       = "Volume [L]";

       set_param(Model_ZS + "/HP" + i + "/HP1", ...
                "T0S", "T0" + n, "P0S", "P0" + n, "VS", "VS" + n);
    end

    %% Auslegung für ausgehenden Bus

    set_param(Model_Sub + "/Hauptdemux", "Outputs",num2str(dem_out))
    set_param(Model_Sub + "/SPP_Vec", "NumInputs", SP_str)
    set_param(Model_Sub + "/SPL_Vec", "NumInputs", SP_str)
    set_param(Model_Sub + "/ZWP_Vec", "NumInputs", ZS_str)
    set_param(Model_Sub + "/ZWL_Vec", "NumInputs", ZS_str)
    n = 10;

    for i = 1:SP_no
        add_line(Model_Sub,"Hauptdemux/" + num2str(n), "SPP_Vec/" + i,"autorouting","smart")
        add_line(Model_Sub,"Hauptdemux/" + num2str(n + SP_no), "SPL_Vec/" + i,"autorouting","smart")
        n = n + 1;
    end
    n = n + SP_no;   
    for i = 1:ZS_no
        add_line(Model_Sub,"Hauptdemux/" + num2str(n), "ZWP_Vec/" + i,"autorouting","smart")
        add_line(Model_Sub,"Hauptdemux/" + num2str(n + ZS_no), "ZWL_Vec/" + i,"autorouting","smart")
        n = n + 1;
    end
    n = n + ZS_no;
    add_line(Model_Sub,"Hauptdemux/" + n,"Bus/14","autorouting","smart")
    HDP = get_param(get_param(Model_Sub + "/Hauptdemux", "Porthandles").Outport(n), "Line");
    set_param(HDP,"Name","HP")
    
    Model_Pr    = gcb + "/Bus_prep";
    Model_Out   = gcb + "/Dispenseroutput";

    Tanks       = find_system(gcs,"FindAll","On","RegExp","On","Name","Tank\d");
    Tanks2      = find_system(gcs,"FindAll","On","Name","Tank");
    D_No        = length(Tanks) + length(Tanks2);
    D_str       = string(D_No);
    Bus_str     = "";

    for i = 1:D_No
        i_str = string(i);
        Bus_str = Bus_str + "Dis" + i_str;
        if i < D_No
            Bus_str = Bus_str + ",";
        end
    end

    set_param(gcb + "/Dis_Bus", "Inputs", Bus_str)
    set_param(Model_Pr + "/Dis_Sel","OutputSignals",Bus_str)
    set_param(Model_Out + "/Dis_Sel","OutputSignals",Bus_str)
    
    ZS_str      = Mask_MS.getParameter("Zwischen_Anzahl").Value;
    ZS_no       = str2double(ZS_str);
    SP_str      = Mask_MS.getParameter("Tank_Anzahl").Value;
    SP_no       = str2double(SP_str);
    Sum_no      = SP_no + ZS_no;
    Sum_str     = string(Sum_no);

    set_param(Model_Pr + "/NF_Mux","Inputs", D_str)
    set_param(Model_Pr + "/SP_Vec_Mux","Inputs", D_str)

    posy        = -50;
    posy2       = -150;
    posy3       = -5;
    posy4       = 43;
    
    for i = 1:D_No
        i_str = num2str(i);

        add_block("simulink/Sources/In1",gcb + "/Dis1", "Position",[-150, posy, -120, posy + 15],"MakeNameUnique","on")
        add_block("HRS_Library/Sonstiges/SP_Vec_Prep", Model_Pr + "/SP_Vec_Prep1","MakeNameUnique","on","Position",[300, posy2, 450, posy2 + 60],"LinkStatus","none")
        add_block("simulink/Sinks/Out1",gcb + "/DisOut1", "Position",[1000, posy, 1030, posy + 15],"MakeNameUnique","on")
        
        line = add_line(gcb, "Dis" + i_str + "/1", "Dis_Bus/" + i_str,"autorouting","on");
        set_param(line,"Name","Dis" + i_str)

        %% Änderungen in Vector Prep
        add_line(Model_Pr, "Dis_Sel/" + i_str, "SP_Vec_Prep" + i_str + "/1", "autorouting", "on")
        add_line(Model_Pr, "SP_Vec_Prep" + i_str + "/1", "NF_Mux/" + i_str,"autorouting","on")
        add_line(Model_Pr, "SP_Vec_Prep" + i_str + "/2", "SP_Vec_Mux/" + i_str,"autorouting","on")

        %% Änderungen Dispenseroutput
        add_block("HRS_Library/Sonstiges/Disp_Bus_Out_",Model_Out + "/Disp_Bus_Out1", "Position", [400, posy3, 550, posy3 + 105],"MakeNameUnique","on")
        add_line(Model_Out, "Sp_Info/1", "Disp_Bus_Out" + i_str + "/1","autorouting","on")
        add_line(Model_Out, "Dis_Sel/" + i_str, "Disp_Bus_Out" + i_str + "/2","autorouting","on")
        add_line(Model_Out, "Speicherdrücke/1", "Disp_Bus_Out" + i_str + "/3","autorouting","on")
        add_line(Model_Out, "Lock/1", "Disp_Bus_Out" + i_str + "/4","autorouting","on")

        add_block("simulink/Sinks/Out1", Model_Out + "/Out1", "Position", [750, posy4, 780, posy4 + 14], "MakeNameUnique","on")
        add_line(Model_Out, "Disp_Bus_Out" + i_str + "/1", "Out" + i_str + "/1","autorouting","on")

        %% Output Verbinden
        add_line(gcb, "Dispenseroutput/" + i_str, "DisOut" + i_str + "/1","autorouting","smart")
       
        posy    = posy + 50;
        posy2   = posy2 + 100;
        posy3   = posy3 + 150;
        posy4   = posy4 + 150;
    end

    open_system(gcb,"Mask");
    open_system(Model_SA, "Mask");